<?php
session_start();
if (!isset($_SESSION["admin_logged_in"])) {
    header("Location: admin_login.php");
    exit();
}

$conn = new mysqli("localhost", "root", "", "spiritan_admissions");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Update status if requested
if (isset($_GET['action']) && isset($_GET['id'])) {
    $status = $_GET['action'] === 'approve' ? 'Approved' : 'Disapproved';
    $stmt = $conn->prepare("UPDATE applications SET status=? WHERE id=?");
    $stmt->bind_param("si", $status, $_GET['id']);
    $stmt->execute();
    header("Location: dashboard.php");
    exit();
}

$filter = $_GET['filter'] ?? 'all';
switch ($filter) {
    case 'approved':
        $applications = $conn->query("SELECT * FROM applications WHERE status='Approved' ORDER BY id DESC");
        break;
    case 'disapproved':
        $applications = $conn->query("SELECT * FROM applications WHERE status='Disapproved' ORDER BY id DESC");
        break;
    default:
        $applications = $conn->query("SELECT * FROM applications ORDER BY id DESC");
        break;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Dashboard</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #eef2f5;
            padding: 30px;
        }
        h2 {
            text-align: center;
        }
        .filter-print {
            text-align: center;
            margin-bottom: 15px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            font-size: 14px;
        }
        th {
            background: #007bff;
            color: white;
        }
        a {
            color: #007bff;
            text-decoration: none;
        }
        .btn {
            padding: 5px 10px;
            border-radius: 4px;
            background: #28a745;
            color: white;
            margin: 2px;
            text-decoration: none;
        }
        .btn.disapprove {
            background: #dc3545;
        }
        .btn.print {
            background: #6c757d;
        }
        .status {
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h2>SIGSS Applications Dashboard</h2>

    <div class="filter-print">
        <form method="get" style="display:inline-block;">
            <label for="filter">Filter:</label>
            <select name="filter" id="filter" onchange="this.form.submit()">
                <option value="all" <?= $filter === 'all' ? 'selected' : '' ?>>All</option>
                <option value="approved" <?= $filter === 'approved' ? 'selected' : '' ?>>Approved</option>
                <option value="disapproved" <?= $filter === 'disapproved' ? 'selected' : '' ?>>Disapproved</option>
            </select>
        </form>
        <button onclick="window.print()" class="btn print">🖨️ Print List</button>
    </div>

    <table>
        <tr>
            <th>Form No</th>
            <th>Name</th>
            <th>Email</th>
            <th>Class</th>
            <th>Passport</th>
            <th>Receipt</th>
            <th>Date</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
        <?php while ($row = $applications->fetch_assoc()): ?>
        <tr>
            <td><?= $row["form_number"] ?></td>
            <td><?= $row["full_name"] ?></td>
            <td><?= $row["email"] ?></td>
            <td><?= $row["class_intended"] ?></td>
            <td>
                <?= !empty($row['passport_path']) 
                    ? "<a href='" . htmlspecialchars($row['passport_path']) . "' target='_blank'>View</a>" 
                    : "<span class='text-muted'>Not Uploaded</span>"; ?>
            </td>
            <td>
                <?= !empty($row['receipt_path']) && file_exists($row['receipt_path']) 
                    ? "<a href='" . htmlspecialchars($row['receipt_path']) . "' target='_blank'>View</a>" 
                    : "<span class='text-muted'>Not Uploaded</span>"; ?>
            </td>
            <td><?= $row["created_at"] ?></td>
            <td class="status"><?= $row["status"] ?? "Pending" ?></td>
            <td>
                <a class="btn" href="?action=approve&id=<?= $row['id'] ?>">Approve</a>
                <a class="btn disapprove" href="?action=disapprove&id=<?= $row['id'] ?>">Disapprove</a>
            </td>
        </tr>
        <?php endwhile; ?>
    </table>
</body>
</html>
